﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using CashierCrisis.Managers;

namespace CashierCrisis.UserInterface
{
    public class HelpUI : UI
    {
        UIButton backButton;
        InputManager input;

        public HelpUI(Game game) 
            : base(game)
        {
            FontManager fontManager = CashierGame.Instance.Services.GetService(typeof(FontManager)) as FontManager;
            SpriteFont font = fontManager.GetFont("Default");
            input = CashierGame.Instance.Services.GetService(typeof(InputManager)) as InputManager;

            backButton = new UIButton("Back", Color.Yellow);
            backButton.Font = font;
            backButton.Position = new Microsoft.Xna.Framework.Vector2(SceneManager.RightAlign, 500);
            backButton.Visible = true;

            AddWidget(backButton);
        }

        public override void WidgetCallback(UIWidget widget)
        {
            if (widget == backButton)
            {
                SceneManager.ChangeScene("MainMenu");
                UIManager.PopUserInterface();
                UIManager.SwapUserInterface("MainMenu");
            }
        }

        public override void Update(GameTime gameTime)
        {
            if (input.ConfirmButton())
            {
                IButton button = (IButton)SelectedWidget();
                button.OnPressed();
            }
            base.Update(gameTime);
        }

       



    }
}
